REBOL [
    Title: "Site Mapper for LMS Web Pages"
    Date: "14 Nov 2002"
    Version: 1.0.0
    File: %Sitemapper.r
    Author: "Dick Whiting"
    Purpose: "Reads templates and creates a complete site map for the LMS pages"
    Email: dwhiting@europa.com
    Category: [util]
]

; Site Mapper should be in the root directory for the Site
; Directories, etc. referenced by BuildLMS generator

sourcedir: what-dir
modeldir:  rejoin [sourcedir "models/"]
pagesdir:  rejoin [sourcedir "pages/"]
templdir:  rejoin [sourcedir "templates/"]
templates: load templdir

change-dir templdir              ; Change to templates directory

textout:   copy []               ; used to store lines for sitemap.txt
fileout:   rejoin [sourcedir "sitemap/sitemap.txt"]
namestack: copy []               ; used to track current page name
linkorder: copy ["dummy"]        ; used to determine NEXT & PREV links

        

if exists? fileout [delete fileout]

; Some constants for convenience

space3:  "   "
href: {<a href="&&url"><b>&&title</b></a><br>}

;;;;;;;; FUNCTIONS IN TEMPLATES WITH NO USE IN SITE MAPPER

_wm-start: func [] []
_wm-start-menu: func [] []
_wm-end-menu: func [] []
_wm-start-text: func [] []
_wm-end-text: func [] []
_welcomefoot: func [] []
_wm-end: func [] []
_urls: func [ /local links blk] []
_premenu: func [filein [file!] /style class /nobr /local blk br] []
_sectend: func [ /last] []
_text: func [filein [file!] /style class /nobr /local blk br] []
_image: func [filein [string!] width height [integer!] alt [string!] /local str] []
_listbeg: func [type [string!] /style class /local ublk ul] []
_list: func [filein [file!] /local blk lchar] []
_listend: func [ /local ul] []
_top: func [] []
_foot: func [] []

;;;;;;;; FUNCTIONS TO CREATE & OUTPUT GENERATED HTML PAGE

_out: func [text [string!]] [
      write/append fileout rejoin [text newline]
]

;_out: :print      ; for debugging

_basename: func [filename [string!] /local fn] [
      return copy/part filename find filename ".htm"
]

our-page?: func [filename] [
	return not found? find filename "://" 
]

external-link?: func [filename] [
	return found? find filename ".htm"
]

indent: func [lvl [integer!]] [
	either lvl < 0 [
		spacer: copy skip spacer 3
	] [
		spacer: head rejoin [spacer space3]
	]    
]

map-external: func [url [string!]] [
      if (our-page? url) and (external-link? url) [
         indent +1
		 mapit  _basename url
         indent -1
	] 
]

; Functions that create Site Map from Welcome page template information
; !!! These have the correct URL for href statements

_welcomehead: func [filename [string!]] [
	head insert head namestack filename
      insert tail linkorder rejoin [filename ".htm"]
]

_wm-title: func [title [string!]] [
	spacer: copy ""
	append textout rejoin ["<br><b>"title"</b>" "<br><br>"]
]

_wm-item: func [title url [string!] /local str] [ 
	spacer: copy ""  
      str: copy href
      replace str "&&url" url
      replace str "&&title" title   
	append textout rejoin [spacer str]
      map-external url
]

_wm-subitem: func [title url [string!] /local str] [
      indent +1       
      str: copy href
      replace str "&&url" url
      replace str "&&title" title   
      append textout rejoin [spacer str]
      map-external url
      indent -1
]

; Functions that create Site Map from STANDARD page template information 

_head: func [title filename author [string!]] [
	head insert head namestack filename
      insert tail linkorder rejoin [filename ".htm"]
]

_addtomenu: func [title url [string!] /sub /local str] [
      if sub [indent +1]
      str: copy href
      replace str "&&url" url
      replace str "&&title" title   
      append textout rejoin [spacer str]
      map-external url
      if sub [indent -1]
]

_sectbeg: func [title link [string!] /nomenu /local str url] [
	if not nomenu [
 	     url: rejoin [first namestack ".htm#" link]
	     str: copy href
	     replace str "&&url" url
 	     replace str "&&title" title   
	     append textout rejoin [spacer str]
	]
]

_sectsub: func [title link [string!] /nomenu /local str url] [
	if not nomenu [
          indent +1
          url: rejoin [first namestack ".htm#" link]
          str: copy href
          replace str "&&url" url
          replace str "&&title" title   
          append textout rejoin [spacer str]
          indent -1
      ]
]

_done: func [] [
	head remove/part head namestack 1
]

mapit: func [page [string!] /local fn] [
	fn: to-file rejoin [page ".template"]
	either exists? fn [do read fn] [
		print [newline fn "NOT FOUND" newline]
	]
]

mapit "welcome"

; Reprocess the text created and insert <ul> </ul> statements in the appropriate
; places as the site map file is being written.
; Each indentation is 3 spaces (reason for (cnt / 3) 

oldcnt: 0
cnt: 0

_out "<ul>"
foreach line textout [
	cnt: (length? line) - (length? trim/head copy line)
      diff: cnt - oldcnt
      either cnt > oldcnt [
            ul: head insert/dup head copy "<ul>" space3 (cnt / 3)
		    _out ul
            _out line
            oldcnt: cnt
	] [
            ends: to-integer (1 + (oldcnt - cnt) / 3)
            for i ends 1 -1 [
                  ul: head insert/dup copy "</ul>" space3 (cnt / 3)
			ul: head insert/dup head ul space3 i
                  _out ul
		]
            if diff > 0 [
			ul: head insert/dup head copy "<ul>" space3 (cnt / 3)
			_out ul
		]
		_out line
            oldcnt: cnt
	]
]
_out "</ul>"

; Save out the link order information

head insert tail linkorder "welcome.htm" 
print [newline "Saving linkorder.txt in" templdir newline]
save rejoin [templdir "linkorder.txt" ] linkorder

ans: ""
if ans <> "Q" [ask [ newline "ANY key to QUIT" newline]]






